<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $campiAggiuntiviRicerca = array("tipoRicerca"=>"scontoGruppi","status"=>102);
    if(isset($_GET["cerca"]) && $_GET["tipoRicerca"]=="scontoGruppi") {
        $cercaGruppi = $_GET["cerca"];
        $parametriRicerca = array("nome"=>filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES));
    }
    else {
        $cercaGruppi = "";
        $parametriRicerca = array();
    }
    
    $parametri = array("tabella"=>"geec_gruppi", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricercaStrutture = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"index.php");
?>
    <h4 class="mb-4 title">Sconti gruppi</h4>
    <hr>

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricercaStrutture->stampaSelectNumeroElementi($cercaGruppi,$campiAggiuntiviRicerca);
            $ricercaStrutture->stampaFormRicerca($cercaGruppi,$campiAggiuntiviRicerca);
        ?>
    </div>
    <div class="table-responsive table-sm">
    
        <?php

            if(isset($_GET["pag"])) {
                $ris = $ricercaStrutture->eseguiRicerca($_GET["pag"],"OR");
            }
            else {
                $ris = $ricercaStrutture->eseguiRicerca(1,"OR");
            }
            
            $colonne = array("ID","Nome","Sconto %","");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
            $tabella->setTipo("normale");
            while($gruppo = $ris->fetch_assoc()) {
                $formModificaSconto = "<form class=\"d-inline-flex mr-sm-1\">
                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                        <input type=\"number\" id=\"scontoGruppo{$gruppo["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$gruppo["percentualeSconto"]}\">
                        <div class=\"input-group-append\">
                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"modificaPercentualeScontoGruppo({$gruppo["id"]})\">Salva</button>
                        </div>
                    </div>
                </form>";

                $tabella->aggiungiNuovaRiga(array($gruppo["id"],"<b>".$gruppo["nome"]."</b>",$formModificaSconto),array());
            }
            $tabella->stampa("rigaProdotto",0);
            $ricercaStrutture->stampaPaginazione(true,"index.php");
        ?>
    </div>